/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AzraOddsmakerDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference mor;
    private final String creatureName;

    public AzraOddsmakerDelayedTriggeredAbility(MageObjectReference mor, String creatureName) {
        super((Effect)new DrawCardSourceControllerEffect(2), Duration.EndOfTurn, false, false);
        this.mor = mor;
        this.creatureName = creatureName;
    }

    private AzraOddsmakerDelayedTriggeredAbility(AzraOddsmakerDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
        this.creatureName = ability.creatureName;
    }

    public AzraOddsmakerDelayedTriggeredAbility copy() {
        return new AzraOddsmakerDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (((DamagedPlayerEvent)event).isCombatDamage()) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
            return this.mor.refersTo((MageObject)permanent, game);
        }
        return false;
    }

    public String getRule() {
        return "Whenever " + this.creatureName + " deals combat damage to a player this turn, you draw two cards";
    }
}

