/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChooseHumanMerfolkOrGoblinEffect
extends OneShotEffect {
    public static final String SECRET_CREATURE_TYPE = "_susCreatureType";
    public static final String SECRET_OWNER = "_secOwn";

    ChooseHumanMerfolkOrGoblinEffect() {
        super(Outcome.Neutral);
        this.staticText = "Then secretly choose Human, Merfolk, or Goblin.";
    }

    private ChooseHumanMerfolkOrGoblinEffect(ChooseHumanMerfolkOrGoblinEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChooseHumanMerfolkOrGoblinEffect copy() {
        return new ChooseHumanMerfolkOrGoblinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        LinkedHashSet<String> choices = new LinkedHashSet<String>();
        choices.add("Human");
        choices.add("Merfolk");
        choices.add("Goblin");
        choice.setChoices(choices);
        choice.setMessage("Choose Human, Merfolk, or Goblin");
        controller.choose(this.outcome, (Choice)choice, game);
        game.informPlayers(permanent.getName() + ": " + controller.getLogName() + " has secretly chosen a creature type.");
        SubType chosenType = SubType.byDescription((String)choice.getChoice());
        ChooseHumanMerfolkOrGoblinEffect.setSecretCreatureType(chosenType, source, game);
        ChooseHumanMerfolkOrGoblinEffect.setSecretOwner(source.getControllerId(), source, game);
        return true;
    }

    public static void setSecretCreatureType(SubType type, Ability source, Game game) {
        String uniqueRef = ChooseHumanMerfolkOrGoblinEffect.getUniqueReference(source, game);
        if (uniqueRef != null) {
            game.getState().setValue(uniqueRef + SECRET_CREATURE_TYPE, (Object)type);
        }
    }

    public static SubType getSecretCreatureType(Ability source, Game game) {
        String uniqueRef = ChooseHumanMerfolkOrGoblinEffect.getUniqueReference(source, game);
        if (uniqueRef != null) {
            return (SubType)game.getState().getValue(uniqueRef + SECRET_CREATURE_TYPE);
        }
        return null;
    }

    public static void setSecretOwner(UUID owner, Ability source, Game game) {
        String uniqueRef = ChooseHumanMerfolkOrGoblinEffect.getUniqueReference(source, game);
        if (uniqueRef != null) {
            game.getState().setValue(ChooseHumanMerfolkOrGoblinEffect.getUniqueReference(source, game) + SECRET_OWNER, (Object)owner);
        }
    }

    public static UUID getSecretOwner(Ability source, Game game) {
        String uniqueRef = ChooseHumanMerfolkOrGoblinEffect.getUniqueReference(source, game);
        if (uniqueRef != null) {
            return (UUID)game.getState().getValue(ChooseHumanMerfolkOrGoblinEffect.getUniqueReference(source, game) + SECRET_OWNER);
        }
        return null;
    }

    private static String getUniqueReference(Ability source, Game game) {
        if (game.getPermanentOrLKIBattlefield(source.getSourceId()) != null) {
            return source.getSourceId() + "_" + game.getPermanentOrLKIBattlefield(source.getSourceId()).getZoneChangeCounter(game);
        }
        return null;
    }
}

