/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BackForMoreDamageEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    BackForMoreDamageEffect(MageObjectReference mor) {
        super(Outcome.Benefit);
        this.mor = mor;
    }

    private BackForMoreDamageEffect(BackForMoreDamageEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public BackForMoreDamageEffect copy() {
        return new BackForMoreDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (this.mor == null) {
            return false;
        }
        Permanent creature = game.getPermanent(source.getFirstTarget());
        Permanent permanent = this.mor.getPermanent(game);
        if (creature == null || permanent == null) {
            return false;
        }
        return permanent.fight(creature, source, game);
    }
}

