/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;

class BalancingActSacrificeEffect
extends OneShotEffect {
    BalancingActSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Each player chooses a number of permanents they control equal to the number of permanents controlled by the player who controls the fewest, then sacrifices the rest.";
    }

    private BalancingActSacrificeEffect(BalancingActSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public BalancingActSacrificeEffect copy() {
        return new BalancingActSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int minPermanent = Integer.MAX_VALUE;
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            minPermanent = Math.min(minPermanent, game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledPermanent(), player.getId(), source, game).size());
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            TargetControlledPermanent target;
            player = game.getPlayer(playerId);
            if (player == null || !(target = new TargetControlledPermanent(minPermanent, minPermanent, new FilterControlledPermanent(), true)).choose(Outcome.Benefit, player.getId(), source.getSourceId(), source, game)) continue;
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledPermanent(), player.getId(), source, game)) {
                if (permanent == null || target.getTargets().contains(permanent.getId())) continue;
                permanent.sacrifice(source, game);
            }
        }
        return true;
    }
}

