/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BallistaWielderEffect
extends OneShotEffect {
    BallistaWielderEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 1 damage to any target. A creature dealt damage this way can't block this turn";
    }

    private BallistaWielderEffect(BallistaWielderEffect effect) {
        super((OneShotEffect)effect);
    }

    public BallistaWielderEffect copy() {
        return new BallistaWielderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            return player != null && player.damage(1, source, game) > 0;
        }
        if (permanent.damage(1, source, game) <= 0) {
            return false;
        }
        game.addEffect((ContinuousEffect)new CantBlockTargetEffect(Duration.EndOfTurn), source);
        return true;
    }
}

