/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class BalthorTheDefiledEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard();

    public BalthorTheDefiledEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player returns all black and all red creature cards from their graveyard to the battlefield";
    }

    private BalthorTheDefiledEffect(BalthorTheDefiledEffect effect) {
        super((OneShotEffect)effect);
    }

    public BalthorTheDefiledEffect copy() {
        return new BalthorTheDefiledEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cardsToReturn = new CardsImpl();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                cardsToReturn.addAllCards((Collection)player.getGraveyard().getCards((FilterCard)filter, source.getControllerId(), source, game));
            }
            controller.moveCards(cardsToReturn.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.BLACK), (Predicate)new ColorPredicate(ObjectColor.RED)));
    }
}

