/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class BamboozleEffect
extends OneShotEffect {
    BamboozleEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals the top four cards of their library. You choose two of those cards and put them into that player's graveyard. Put the rest on top of their library in any order";
    }

    private BamboozleEffect(BamboozleEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        CardsImpl putOnTopLibrary = new CardsImpl();
        CardsImpl putInGraveyard = new CardsImpl();
        if (targetPlayer != null && controller != null) {
            Set top4Cards = targetPlayer.getLibrary().getTopCards(game, 4);
            for (Card card : top4Cards) {
                putOnTopLibrary.add(card);
            }
            targetPlayer.revealCards("Bamboozle Reveal", (Cards)putOnTopLibrary, game);
            TargetCard target = new TargetCard(2, Zone.LIBRARY, new FilterCard("2 cards out of this stack to put into their graveyard"));
            if (controller.choose(Outcome.Discard, (Cards)putOnTopLibrary, target, source, game)) {
                for (UUID cardId : target.getTargets()) {
                    putInGraveyard.add(game.getCard(cardId));
                    putOnTopLibrary.remove(game.getCard(cardId));
                }
                targetPlayer.moveCards((Cards)putInGraveyard, Zone.GRAVEYARD, source, game);
                targetPlayer.putCardsOnTopOfLibrary((Cards)putOnTopLibrary, game, source, true);
                return true;
            }
        }
        return false;
    }

    public BamboozleEffect copy() {
        return new BamboozleEffect(this);
    }
}

