/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BanishmentEffect
extends OneShotEffect {
    BanishmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target nonland permanent an opponent controls and all other nonland permanents your opponents control with the same name as that permanent until {this} leaves the battlefield";
    }

    private BanishmentEffect(BanishmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent targeted = game.getPermanent(source.getFirstTarget());
        if (permanent == null || controller == null || targeted == null) {
            return false;
        }
        FilterNonlandPermanent filter = new FilterNonlandPermanent();
        filter.add((Predicate)new NamePredicate(targeted.getName()));
        Set toExile = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game).stream().filter(p -> controller.hasOpponent(p.getControllerId(), game)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!toExile.isEmpty()) {
            controller.moveCardsToExile(toExile, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), permanent.getIdName());
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        }
        return true;
    }

    public BanishmentEffect copy() {
        return new BanishmentEffect(this);
    }
}

