/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.token.FirstMateRagavanToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class BaralAndKariZevEffect
extends OneShotEffect {
    BaralAndKariZevEffect() {
        super(Outcome.Benefit);
    }

    private BaralAndKariZevEffect(BaralAndKariZevEffect effect) {
        super((OneShotEffect)effect);
    }

    public BaralAndKariZevEffect copy() {
        return new BaralAndKariZevEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (player == null || spell == null) {
            return false;
        }
        FilterCard filter = new FilterCard();
        filter.add(Predicates.or((Iterable)spell.getCardType(game).stream().map(CardType::getPredicate).collect(Collectors.toList())));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, spell.getManaValue()));
        if (CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)player.getHand(), (FilterCard)filter)) {
            return true;
        }
        FirstMateRagavanToken token = new FirstMateRagavanToken();
        token.putOntoBattlefield(1, game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        return true;
    }
}

