/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BarbarianBullyEffect
extends OneShotEffect {
    BarbarianBullyEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} gets +2/+2 until end of turn unless a player has {this} deal 4 damage to them";
    }

    private BarbarianBullyEffect(BarbarianBullyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BarbarianBullyEffect copy() {
        return new BarbarianBullyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        boolean costPaid = false;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(Outcome.UnboostCreature, "Have " + permanent.getName() + " deal 4 damage to you?", source, game)) continue;
            player.damage(4, permanent.getId(), source, game);
            costPaid = true;
        }
        if (!costPaid) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(2, 2, Duration.EndOfTurn), source);
        }
        return true;
    }
}

