/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class BarishiEffect
extends OneShotEffect {
    BarishiEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile {this}, then shuffle all creature cards from your graveyard into your library";
    }

    private BarishiEffect(BarishiEffect effect) {
        super((OneShotEffect)effect);
    }

    public BarishiEffect copy() {
        return new BarishiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        new ExileSourceEffect().apply(game, source);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        controller.putCardsOnTopOfLibrary((Cards)cards, game, source, false);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

