/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BaronVonCountDestroyPlayerEffect
extends OneShotEffect {
    BaronVonCountDestroyPlayerEffect() {
        super(Outcome.Neutral);
        this.staticText = "destroy target player and put that doom counter on \"5.\"";
    }

    private BaronVonCountDestroyPlayerEffect(BaronVonCountDestroyPlayerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer != null && targetPlayer.canLose(game)) {
            game.informPlayers(targetPlayer.getLogName() + " was destroyed");
            targetPlayer.lost(game);
        }
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        MageObject mageObject = game.getObject(source);
        if (sourcePermanent != null && mageObject != null) {
            if (game.getState().getValue(mageObject.getId() + "_doom") == null) {
                return false;
            }
            Integer doomNumber = 5;
            game.getState().setValue(mageObject.getId() + "_doom", (Object)doomNumber);
            ((Permanent)mageObject).addInfo("doom counter", CardUtil.addToolTipMarkTags((String)("Doom counter at: " + doomNumber)), game);
            return true;
        }
        return false;
    }

    public BaronVonCountDestroyPlayerEffect copy() {
        return new BaronVonCountDestroyPlayerEffect(this);
    }
}

