/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.BlockingCreatureCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BarrelingAttackTriggeredAbility
extends DelayedTriggeredAbility {
    BarrelingAttackTriggeredAbility() {
        super((Effect)new BoostTargetEffect((DynamicValue)BlockingCreatureCount.TARGET, (DynamicValue)BlockingCreatureCount.TARGET, Duration.EndOfTurn), Duration.EndOfTurn, false);
        this.setTriggerPhrase("When that creature becomes blocked this turn, ");
    }

    private BarrelingAttackTriggeredAbility(BarrelingAttackTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATURE_BLOCKED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getFirstTarget())) {
            Permanent attackingCreature = game.getPermanentOrLKIBattlefield(event.getTargetId());
            return attackingCreature != null;
        }
        return false;
    }

    public BarrelingAttackTriggeredAbility copy() {
        return new BarrelingAttackTriggeredAbility(this);
    }
}

