/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class BartelRuneaxeEffect
extends ContinuousRuleModifyingEffectImpl {
    BartelRuneaxeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "{this} can't be the target of Aura spells";
    }

    private BartelRuneaxeEffect(BartelRuneaxeEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public BartelRuneaxeEffect copy() {
        return new BartelRuneaxeEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            return sourcePermanent.getLogName() + " can't be the target of Aura spells";
        }
        return null;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        return stackObject != null && event.getTargetId().equals(source.getSourceId()) && stackObject.hasSubtype(SubType.AURA, game);
    }
}

