/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaPaidEvent;
import mage.game.events.ZoneChangeEvent;
import mage.util.Copyable;
import mage.watchers.Watcher;

class BatColonyWatcher
extends Watcher {
    private static final CaveManaPaidTracker emptyTracker = new CaveManaPaidTracker();
    private final Map<UUID, CaveManaPaidTracker> manaMap = new HashMap<UUID, CaveManaPaidTracker>();

    public BatColonyWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ZONE_CHANGE: {
                if (((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD || ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD) {
                    this.manaMap.remove(event.getTargetId());
                }
                return;
            }
            case MANA_PAID: {
                ManaPaidEvent manaEvent = (ManaPaidEvent)event;
                this.manaMap.computeIfAbsent(manaEvent.getTargetId(), x -> new CaveManaPaidTracker()).increment(manaEvent.getSourceObject(), game);
                this.manaMap.computeIfAbsent(manaEvent.getSourcePaidId(), x -> new CaveManaPaidTracker()).increment(manaEvent.getSourceObject(), game);
            }
        }
    }

    public void reset() {
        super.reset();
        this.manaMap.clear();
    }

    public static int getCaveAmount(UUID sourceId, Game game) {
        BatColonyWatcher watcher = (BatColonyWatcher)game.getState().getWatcher(BatColonyWatcher.class);
        return watcher == null ? 0 : watcher.manaMap.getOrDefault(sourceId, emptyTracker).caveMana;
    }

    private static final class CaveManaPaidTracker
    implements Serializable,
    Copyable<CaveManaPaidTracker> {
        private int caveMana = 0;

        private CaveManaPaidTracker() {
        }

        private CaveManaPaidTracker(CaveManaPaidTracker tracker) {
            this.caveMana = tracker.caveMana;
        }

        public CaveManaPaidTracker copy() {
            return new CaveManaPaidTracker(this);
        }

        private void increment(MageObject sourceObject, Game game) {
            if (sourceObject != null && sourceObject.hasSubtype(SubType.CAVE, game)) {
                ++this.caveMana;
            }
        }
    }
}

