/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.b.ProtectionChosenColorTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BatheInLightEffect
extends OneShotEffect {
    BatheInLightEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a color. Target creature and each other creature that shares a color with it gain protection from the chosen color until end of turn";
    }

    private BatheInLightEffect(BatheInLightEffect effect) {
        super((OneShotEffect)effect);
    }

    public BatheInLightEffect copy() {
        return new BatheInLightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target == null) {
            return false;
        }
        ChoiceColor colorChoice = new ChoiceColor();
        if (!controller.choose(Outcome.Benefit, (Choice)colorChoice, game)) {
            return false;
        }
        game.informPlayers(target.getName() + ": " + controller.getLogName() + " has chosen " + colorChoice.getChoice());
        game.getState().setValue(target.getId() + "_color", (Object)colorChoice.getColor());
        ObjectColor protectColor = (ObjectColor)game.getState().getValue(target.getId() + "_color");
        if (protectColor == null) {
            return true;
        }
        ProtectionChosenColorTargetEffect effect = new ProtectionChosenColorTargetEffect();
        game.addEffect((ContinuousEffect)effect, source);
        ObjectColor color = target.getColor(game);
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (permanent.getId().equals(target.getId()) || !permanent.getColor(game).shares(color)) continue;
            game.getState().setValue(permanent.getId() + "_color", (Object)colorChoice.getColor());
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

