/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.b.BattleForBretagardTarget;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BattleForBretagardEffect
extends OneShotEffect {
    BattleForBretagardEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose any number of artifact tokens and/or creature tokens you control with different names. For each of them, create a token that's a copy of it.";
    }

    private BattleForBretagardEffect(BattleForBretagardEffect effect) {
        super((OneShotEffect)effect);
    }

    public BattleForBretagardEffect copy() {
        return new BattleForBretagardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        BattleForBretagardTarget target = new BattleForBretagardTarget();
        player.choose(this.outcome, (Target)target, source, game);
        for (UUID targetId : target.getTargets()) {
            new CreateTokenCopyTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(targetId, game)).apply(game, source);
        }
        return true;
    }
}

