/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class BattleForBretagardTarget
extends TargetPermanent {
    private static final FilterPermanent filter = new FilterControlledPermanent("artifact tokens and/or creature tokens you control with different names");

    BattleForBretagardTarget() {
        super(0, Integer.MAX_VALUE, filter, true);
    }

    private BattleForBretagardTarget(BattleForBretagardTarget target) {
        super((TargetPermanent)target);
    }

    public BattleForBretagardTarget copy() {
        return new BattleForBretagardTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability ability, Game game) {
        if (!super.canTarget(playerId, id, ability, game)) {
            return false;
        }
        Set names = this.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageObject::getName).collect(Collectors.toSet());
        names.removeIf(Objects::isNull);
        names.removeIf(String::isEmpty);
        Permanent permanent = game.getPermanent(id);
        return permanent != null && !names.contains(permanent.getName());
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Set names = this.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageObject::getName).collect(Collectors.toSet());
        names.removeIf(Objects::isNull);
        names.removeIf(String::isEmpty);
        possibleTargets.removeIf(uuid -> {
            Permanent permanent = game.getPermanent(uuid);
            return permanent == null || names.contains(permanent.getName());
        });
        return possibleTargets;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

