/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.util.CardUtil;

class BattlefieldThaumaturgeSpellsCostReductionEffect
extends CostModificationEffectImpl {
    BattlefieldThaumaturgeSpellsCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Each instant and sorcery spell you cast costs {1} less to cast for each creature it targets";
    }

    protected BattlefieldThaumaturgeSpellsCostReductionEffect(BattlefieldThaumaturgeSpellsCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int reduceAmount;
        if (game.inCheckPlayableState()) {
            reduceAmount = this.getMaxPossibleTargetCreatures(abilityToModify, game);
        } else {
            HashSet<UUID> creaturesTargeted = new HashSet<UUID>();
            for (Target target : abilityToModify.getAllSelectedTargets()) {
                if (target.isNotTarget()) continue;
                for (UUID uuid : target.getTargets()) {
                    Permanent permanent = game.getPermanent(uuid);
                    if (permanent == null || !permanent.isCreature(game)) continue;
                    creaturesTargeted.add(permanent.getId());
                }
            }
            reduceAmount = creaturesTargeted.size();
        }
        CardUtil.reduceCost((Ability)abilityToModify, (int)reduceAmount);
        return true;
    }

    private int getMaxPossibleTargetCreatures(Ability ability, Game game) {
        int maxAmount = 0;
        for (Mode mode : ability.getModes().values()) {
            for (Target target : mode.getTargets()) {
                if (target.isNotTarget()) continue;
                Set possibleList = target.possibleTargets(ability.getControllerId(), ability, game);
                possibleList.removeIf(id -> {
                    Permanent permanent = game.getPermanent(id);
                    return permanent == null || !permanent.isCreature(game);
                });
                int possibleAmount = Math.min(possibleList.size(), target.getMaxNumberOfTargets());
                maxAmount = Math.max(maxAmount, possibleAmount);
            }
        }
        return maxAmount;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId())) {
            Spell spell = (Spell)game.getStack().getStackObject(abilityToModify.getId());
            if (spell != null) {
                return StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY.match((Card)spell, game);
            }
            Card sourceCard = game.getCard(abilityToModify.getSourceId());
            return sourceCard != null && StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY.match(sourceCard, game);
        }
        return false;
    }

    public BattlefieldThaumaturgeSpellsCostReductionEffect copy() {
        return new BattlefieldThaumaturgeSpellsCostReductionEffect(this);
    }
}

