/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class BazaarOfWondersEffect
extends OneShotEffect {
    BazaarOfWondersEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter it if a card with the same name is in a graveyard or a nontoken permanent with the same name is on the battlefield";
    }

    private BazaarOfWondersEffect(BazaarOfWondersEffect effect) {
        super((OneShotEffect)effect);
    }

    public BazaarOfWondersEffect copy() {
        return new BazaarOfWondersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        String spellName = spell.getName();
        FilterPermanent filter1 = new FilterPermanent();
        filter1.add((Predicate)new NamePredicate(spellName));
        filter1.add((Predicate)TokenPredicate.FALSE);
        if (!game.getBattlefield().getActivePermanents(filter1, source.getControllerId(), game).isEmpty()) {
            game.getStack().counter(spell.getId(), source, game);
            return true;
        }
        FilterCard filter2 = new FilterCard();
        filter2.add((Predicate)new NamePredicate(spellName));
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getGraveyard().count(filter2, game) <= 0) continue;
            return game.getStack().counter(spell.getId(), source, game);
        }
        return false;
    }
}

