/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.AbilityImpl;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.b.BeamsplitterMageEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;

class BeamsplitterMageTriggeredAbility
extends TriggeredAbilityImpl {
    BeamsplitterMageTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BeamsplitterMageEffect(), false);
    }

    private BeamsplitterMageTriggeredAbility(BeamsplitterMageTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BeamsplitterMageTriggeredAbility copy() {
        return new BeamsplitterMageTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getSpellOrLKIStack(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        if (spell.getSpellAbilities().stream().map(AbilityImpl::getModes).flatMap(m -> m.getSelectedModes().stream().map(arg_0 -> ((Modes)m).get(arg_0))).filter(Objects::nonNull).map(Mode::getTargets).flatMap(Collection::stream).filter(t -> !t.isNotTarget()).map(Target::getTargets).flatMap(Collection::stream).anyMatch(uuid -> !this.getSourceId().equals(uuid) && uuid != null)) {
            return false;
        }
        this.getEffects().setValue("spellCast", (Object)spell);
        return true;
    }

    public boolean checkInterveningIfClause(Game game) {
        Spell spell = (Spell)((Effect)this.getEffects().get(0)).getValue("spellCast");
        if (spell == null) {
            return false;
        }
        return game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, this.getControllerId(), (Ability)this, game).stream().filter(Objects::nonNull).filter(permanent -> permanent.isCreature(game)).filter(p -> this.checkNotSource((Permanent)p, game)).anyMatch(p -> spell.canTarget(game, p.getId()));
    }

    private boolean checkNotSource(Permanent permanent, Game game) {
        if (this.getStackMomentSourceZCC() == 0) {
            return !permanent.getId().equals(this.getSourceId());
        }
        return !permanent.getId().equals(this.getSourceId()) || permanent.getZoneChangeCounter(game) != this.getStackMomentSourceZCC();
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell that targets only {this}, if you control one or more other creatures that spell could target, choose one of those creatures. Copy that spell. The copy targets the chosen creature.";
    }
}

