/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.EquipAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

public final class BeardedAxe
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent();
    private static final DynamicValue xValue;
    private static final Hint hint;

    public BeardedAxe(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}{R}");
        this.subtype.add((Object)SubType.EQUIPMENT);
        this.addAbility(new SimpleStaticAbility((Effect)new BoostEquippedEffect(xValue, xValue).setText("equipped creature gets +1/+1 for each Dwarf, Equipment, and/or Vehicle you control")).addHint(hint));
        this.addAbility((Ability)new EquipAbility(Outcome.BoostCreature, (Cost)new GenericManaCost(2), (Target)new TargetControlledCreaturePermanent(), false));
    }

    private BeardedAxe(BeardedAxe card) {
        super((CardImpl)card);
    }

    public BeardedAxe copy() {
        return new BeardedAxe(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.DWARF.getPredicate(), SubType.EQUIPMENT.getPredicate(), SubType.VEHICLE.getPredicate()}));
        xValue = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Dwarves, Equipment, and/or Vehicles you control", xValue);
    }
}

