/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class BeatrixLoyalGeneralEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.EQUIPMENT);

    BeatrixLoyalGeneralEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may attach any number of Equipment you control to target creature you control";
    }

    private BeatrixLoyalGeneralEffect(BeatrixLoyalGeneralEffect effect) {
        super((OneShotEffect)effect);
    }

    public BeatrixLoyalGeneralEffect copy() {
        return new BeatrixLoyalGeneralEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        for (UUID targetId : target.getTargets()) {
            permanent.addAttachment(targetId, source, game);
        }
        return true;
    }
}

