/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BecomeAnonymousEffect
extends OneShotEffect {
    BecomeAnonymousEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target nontoken creature you own and the top two cards of your library in a face-down pile, shuffle that pile, then cloak those cards. They enter tapped";
    }

    private BecomeAnonymousEffect(BecomeAnonymousEffect effect) {
        super((OneShotEffect)effect);
    }

    public BecomeAnonymousEffect copy() {
        return new BecomeAnonymousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2));
        cards.add((Card)permanent);
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        if (cards.isEmpty()) {
            return true;
        }
        Set cardSet = cards.getCards(game);
        cardSet.stream().forEach(card -> card.setFaceDown(true, game));
        game.processAction();
        return !ManifestEffect.doManifestCards((Game)game, (Ability)source, (Player)player, (Set)cardSet, (boolean)true, (boolean)true).isEmpty();
    }
}

