/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardWithDifferentNameInLibrary;
import mage.util.CardUtil;

class BeginTheInvasionEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("battle cards with different names");

    BeginTheInvasionEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to X battle cards with different names, put them onto the battlefield, then shuffle";
    }

    private BeginTheInvasionEffect(BeginTheInvasionEffect effect) {
        super((OneShotEffect)effect);
    }

    public BeginTheInvasionEffect copy() {
        return new BeginTheInvasionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        return new SearchLibraryPutInPlayEffect((TargetCardInLibrary)new TargetCardWithDifferentNameInLibrary(0, xValue, filter), false).apply(game, source);
    }

    static {
        filter.add((Predicate)CardType.BATTLE.getPredicate());
    }
}

