/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.cards.Card;
import mage.cards.b.BellBorcaSpectralSergeantAbility;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class BellBorcaSpectralSergeantWatcher
extends Watcher {
    private static final FilterPermanent filter = new FilterPermanent();
    private final Map<UUID, Integer> cmcMap = new HashMap<UUID, Integer>();

    BellBorcaSpectralSergeantWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE || ((ZoneChangeEvent)event).getToZone() != Zone.EXILED) {
            return;
        }
        Card card = game.getCard(event.getTargetId());
        if (card == null || card.isFaceDown(game)) {
            return;
        }
        int cmc = card.getManaValue();
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(filter, game)) {
            if (permanent == null || this.cmcMap.get(permanent.getId()) != null && this.cmcMap.get(permanent.getId()) >= cmc) continue;
            this.cmcMap.put(permanent.getId(), cmc);
        }
    }

    public void reset() {
        this.cmcMap.clear();
        super.reset();
    }

    int getValue(UUID sourceId) {
        return this.cmcMap.getOrDefault(sourceId, 0);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(BellBorcaSpectralSergeantAbility.class));
    }
}

