/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BelligerentYearlingEffect
extends OneShotEffect {
    BelligerentYearlingEffect() {
        super(Outcome.Detriment);
        this.staticText = "have {this}'s base power become equal to that creature's power until end of turn";
    }

    private BelligerentYearlingEffect(BelligerentYearlingEffect effect) {
        super((OneShotEffect)effect);
    }

    public BelligerentYearlingEffect copy() {
        return new BelligerentYearlingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller == null || permanent == null) {
            return false;
        }
        SetBasePowerSourceEffect effect = new SetBasePowerSourceEffect(permanent.getPower().getValue(), Duration.EndOfTurn);
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

