/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.DealsCombatDamageToAPlayerTriggeredAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BelloBardOfTheBramblesEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent();

    public BelloBardOfTheBramblesEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BecomeCreature);
        this.staticText = "during your turn, each non-Equipment artifact and non-Aura enchantment you control with mana value 4 or greater is a 4/4 Elemental creature in addition to its other types and has indestructible, haste, and \"Whenever this creature deals combat damage to a player, draw a card.\"";
        this.dependendToTypes.add(DependencyType.EnchantmentAddingRemoving);
        this.dependendToTypes.add(DependencyType.ArtifactAddingRemoving);
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private BelloBardOfTheBramblesEffect(BelloBardOfTheBramblesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (!source.isControlledBy(game.getActivePlayerId())) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                this.affectedObjectList.clear();
                for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                    permanent.addSubType(game, new SubType[]{SubType.ELEMENTAL});
                    this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game));
                }
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                Iterator it = this.affectedObjectList.iterator();
                while (it.hasNext()) {
                    Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
                    if (permanent == null) continue;
                    permanent.addAbility((Ability)IndestructibleAbility.getInstance(), source.getSourceId(), game);
                    permanent.addAbility((Ability)HasteAbility.getInstance(), source.getSourceId(), game);
                    permanent.addAbility((Ability)new DealsCombatDamageToAPlayerTriggeredAbility((Effect)new DrawCardSourceControllerEffect(1)), source.getSourceId(), game);
                }
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) {
                    return false;
                }
                Iterator it = this.affectedObjectList.iterator();
                while (it.hasNext()) {
                    Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
                    if (permanent == null) continue;
                    permanent.getPower().setModifiedBaseValue(4);
                    permanent.getToughness().setModifiedBaseValue(4);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.PTChangingEffects_7;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public BelloBardOfTheBramblesEffect copy() {
        return new BelloBardOfTheBramblesEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
        filter.add(Predicates.not((Predicate)SubType.EQUIPMENT.getPredicate()));
        filter.add(Predicates.not((Predicate)SubType.AURA.getPredicate()));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_GREATER, 4));
    }
}

