/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BellowingFiendEffect
extends OneShotEffect {
    BellowingFiendEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this} deals 3 damage to that creature's controller";
    }

    private BellowingFiendEffect(BellowingFiendEffect effect) {
        super((OneShotEffect)effect);
    }

    public BellowingFiendEffect copy() {
        return new BellowingFiendEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        boolean applied = false;
        Permanent damagedCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (damagedCreature != null && (controller = game.getPlayer(damagedCreature.getControllerId())) != null) {
            controller.damage(3, source.getSourceId(), source, game);
            applied = true;
        }
        return applied;
    }
}

