/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BenefactorsDraughtTriggeredAbility
extends DelayedTriggeredAbility {
    BenefactorsDraughtTriggeredAbility() {
        super((Effect)new DrawCardSourceControllerEffect(1), Duration.EndOfTurn, false);
    }

    private BenefactorsDraughtTriggeredAbility(BenefactorsDraughtTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public BenefactorsDraughtTriggeredAbility copy() {
        return new BenefactorsDraughtTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent blocker = game.getPermanent(event.getSourceId());
        Player controller = game.getPlayer(this.getControllerId());
        return blocker != null && controller != null && game.isOpponent(controller, blocker.getControllerId());
    }

    public String getRule() {
        return "Until end of turn, whenever a creature an opponent controls blocks, draw a card";
    }
}

