/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;

class BindingNegotiationEffect
extends OneShotEffect {
    BindingNegotiationEffect() {
        super(Outcome.Discard);
        this.staticText = "Target opponent reveals their hand. You may choose a nonland card from it. If you do, they discard it. Otherwise, you may put a face-up exiled card they own into their graveyard";
    }

    private BindingNegotiationEffect(BindingNegotiationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (player == null || controller == null) {
            return false;
        }
        CardsImpl revealedCards = new CardsImpl();
        revealedCards.addAll((Collection)player.getHand());
        player.revealCards(source, (Cards)revealedCards, game);
        TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)new FilterNonlandCard());
        controller.choose(this.outcome, (Cards)revealedCards, target, source, game);
        UUID chosenId = target.getFirstTarget();
        if (chosenId != null) {
            Card card = revealedCards.get(target.getFirstTarget(), game);
            player.discard(card, false, source, game);
        } else {
            FilterCard filter = new FilterCard("face-up exiled card owned by " + player.getName());
            filter.add(Predicates.not((Predicate)FaceDownPredicate.instance));
            filter.add((Predicate)new OwnerIdPredicate(player.getId()));
            TargetCardInExile targetExiled = new TargetCardInExile(0, 1, filter);
            controller.choose(this.outcome, (Target)targetExiled, source, game);
            Set chosenExiledCard = targetExiled.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!chosenExiledCard.isEmpty()) {
                player.moveCards(chosenExiledCard, Zone.GRAVEYARD, source, game);
            }
        }
        return true;
    }

    public BindingNegotiationEffect copy() {
        return new BindingNegotiationEffect(this);
    }
}

