/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BiogenicUpgradeEffect
extends OneShotEffect {
    BiogenicUpgradeEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then double the number of +1/+1 counters on each of those creatures.";
    }

    private BiogenicUpgradeEffect(BiogenicUpgradeEffect effect) {
        super((OneShotEffect)effect);
    }

    public BiogenicUpgradeEffect copy() {
        return new BiogenicUpgradeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID permanentId : ((Target)source.getTargets().get(0)).getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(permanent.getCounters(game).getCount(CounterType.P1P1)));
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
        }
        return true;
    }
}

