/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class BiomanticMasteryEffect
extends OneShotEffect {
    BiomanticMasteryEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw a card for each creature target player controls, then draw a card for each creature another target player controls";
    }

    private BiomanticMasteryEffect(BiomanticMasteryEffect effect) {
        super((OneShotEffect)effect);
    }

    public BiomanticMasteryEffect copy() {
        return new BiomanticMasteryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int creatures = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, playerId, game);
            controller.drawCards(creatures, source, game);
        }
        return true;
    }
}

