/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BismuthMindrenderEffect
extends OneShotEffect {
    BismuthMindrenderEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player exiles cards from the top of their library until they exile a nonland card. You may cast that card by paying life equal to the spell's mana value rather than paying its mana cost";
    }

    private BismuthMindrenderEffect(BismuthMindrenderEffect effect) {
        super((OneShotEffect)effect);
    }

    public BismuthMindrenderEffect copy() {
        return new BismuthMindrenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card faceCard;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        Card cardToCast = null;
        for (Card card : targetPlayer.getLibrary().getCards(game)) {
            targetPlayer.moveCards(card, Zone.EXILED, source, game);
            if (card.isLand(game)) continue;
            cardToCast = card;
            break;
        }
        if (cardToCast == null) {
            return false;
        }
        List castableComponents = CardUtil.getCastableComponents(cardToCast, null, (Ability)source, (Player)controller, (Game)game, null, (boolean)false);
        if (castableComponents.isEmpty()) {
            return true;
        }
        String partsInfo = castableComponents.stream().map(MageObject::getLogName).collect(Collectors.joining(" or "));
        if (!controller.chooseUse(Outcome.PlayForFree, "Cast spell by paying life instead of mana (" + partsInfo + ")?", source, game)) {
            return true;
        }
        castableComponents.forEach(partCard -> {
            Boolean cfr_ignored_0 = (Boolean)game.getState().setValue("PlayFromNotOwnHandZone" + partCard.getId(), (Object)Boolean.TRUE);
        });
        SpellAbility chosenAbility = controller.chooseAbilityForCast(cardToCast, game, true);
        if (chosenAbility != null && (faceCard = game.getCard(chosenAbility.getSourceId())) != null) {
            PayLifeCost lifeCost = new PayLifeCost(faceCard.getManaValue());
            CostsImpl newCosts = new CostsImpl();
            newCosts.add((Object)lifeCost);
            newCosts.addAll((Collection)chosenAbility.getCosts());
            controller.setCastSourceIdWithAlternateMana(faceCard.getId(), null, (Costs)newCosts);
            controller.cast(chosenAbility, game, true, new ApprovingObject(source, game));
        }
        castableComponents.forEach(partCard -> game.getState().setValue("PlayFromNotOwnHandZone" + partCard.getId(), null));
        return true;
    }
}

