/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class BitterheartWitchEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Curse card in your library");

    public BitterheartWitchEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may search your library for a Curse card, put it onto the battlefield attached to target player, then shuffle";
    }

    private BitterheartWitchEffect(BitterheartWitchEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (controller != null && targetPlayer != null) {
            Card card;
            TargetCardInLibrary targetCard = new TargetCardInLibrary(filter);
            if (controller.searchLibrary(targetCard, source, game) && (card = game.getCard(targetCard.getFirstTarget())) != null) {
                game.getState().setValue("attachTo:" + card.getId(), (Object)targetPlayer.getId());
                if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
                    targetPlayer.addAttachment(card.getId(), source, game);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public BitterheartWitchEffect copy() {
        return new BitterheartWitchEffect(this);
    }

    static {
        filter.add((Predicate)SubType.CURSE.getPredicate());
    }
}

