/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class BlackPantherWakandanKingEffect
extends OneShotEffect {
    BlackPantherWakandanKingEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "move all +1/+1 counters from target land you control onto target creature. If one or more +1/+1 counters are moved this way, you gain that much life and draw a card.";
    }

    private BlackPantherWakandanKingEffect(BlackPantherWakandanKingEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlackPantherWakandanKingEffect copy() {
        return new BlackPantherWakandanKingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int countersRemoved = 0;
        Permanent landPermanent = game.getPermanent(source.getFirstTarget());
        Permanent creaturePermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (landPermanent == null || creaturePermanent == null || controller == null) {
            return false;
        }
        int numberCounters = landPermanent.getCounters(game).getCount(CounterType.P1P1);
        if (numberCounters > 0) {
            landPermanent.removeCounters(CounterType.P1P1.getName(), numberCounters, source, game);
            countersRemoved += numberCounters;
        }
        if (countersRemoved > 0) {
            creaturePermanent.addCounters(CounterType.P1P1.createInstance(countersRemoved), source.getControllerId(), source, game);
            controller.gainLife(countersRemoved, game, source);
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

