/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class BlackSunsTwilightEffect
extends OneShotEffect {
    BlackSunsTwilightEffect() {
        super(Outcome.Benefit);
        this.staticText = "If X is 5 or more, return a creature card with mana value X or less from your graveyard to the battlefield tapped";
    }

    private BlackSunsTwilightEffect(BlackSunsTwilightEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlackSunsTwilightEffect copy() {
        return new BlackSunsTwilightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player == null || xValue < 5) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + xValue + " or less from your graveyard");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
        if (player.getGraveyard().count((FilterCard)filter, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

