/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BladeOfTheBloodchiefEffect
extends OneShotEffect {
    BladeOfTheBloodchiefEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put a +1/+1 counter on equipped creature. If equipped creature is a Vampire, put two +1/+1 counters on it instead.";
    }

    private BladeOfTheBloodchiefEffect(BladeOfTheBloodchiefEffect ability) {
        super((OneShotEffect)ability);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && (creature = game.getPermanent(enchantment.getAttachedTo())) != null) {
            if (creature.hasSubtype(SubType.VAMPIRE, game)) {
                creature.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
            } else {
                creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            }
        }
        return true;
    }

    public BladeOfTheBloodchiefEffect copy() {
        return new BladeOfTheBloodchiefEffect(this);
    }
}

