/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.MenaceAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BladeOfTheOniEffect
extends ContinuousEffectImpl {
    BladeOfTheOniEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "equipped creature has base power and toughness 5/5, has menace, and is a black Demon in addition to its other colors and types";
    }

    private BladeOfTheOniEffect(BladeOfTheOniEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BladeOfTheOniEffect copy() {
        return new BladeOfTheOniEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(sourcePermanent.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)new MenaceAbility(false), source.getSourceId(), game);
                return true;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setBlack(true);
                return true;
            }
            case TypeChangingEffects_4: {
                permanent.addSubType(game, new SubType[]{SubType.DEMON});
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) {
                    return false;
                }
                permanent.getPower().setModifiedBaseValue(5);
                permanent.getToughness().setModifiedBaseValue(5);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case AbilityAddingRemovingEffects_6: 
            case ColorChangingEffects_5: 
            case TypeChangingEffects_4: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

