/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Set;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BladegraftAspirantCostReductionEffect
extends CostModificationEffectImpl {
    private static final String effectText = "Activated abilities of Equipment you control that target {this} cost {1} less to activate.";

    BladegraftAspirantCostReductionEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = effectText;
    }

    private BladegraftAspirantCostReductionEffect(BladegraftAspirantCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller == null) {
            return false;
        }
        int reduceMax = CardUtil.calculateActualPossibleGenericManaReduction((Mana)abilityToModify.getManaCostsToPay().getMana(), (int)1, (int)0);
        if (reduceMax <= 0) {
            return true;
        }
        CardUtil.reduceCost((Ability)abilityToModify, (int)reduceMax);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!abilityToModify.getAbilityType().isActivatedAbility()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(abilityToModify.getSourceId());
        if (permanent == null || !permanent.hasSubtype(SubType.EQUIPMENT, game) || !permanent.isControlledBy(source.getControllerId())) {
            return false;
        }
        if (game.getStack().getStackObject(abilityToModify.getId()) != null) {
            Set allTargets = CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game);
            return allTargets.contains(source.getSourceId());
        }
        Set allTargets = CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game);
        return allTargets.contains(source.getSourceId());
    }

    public BladegraftAspirantCostReductionEffect copy() {
        return new BladegraftAspirantCostReductionEffect(this);
    }
}

