/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BlazingTorchEffect
extends OneShotEffect {
    BlazingTorchEffect() {
        super(Outcome.Benefit);
    }

    private BlazingTorchEffect(BlazingTorchEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlazingTorchEffect copy() {
        return new BlazingTorchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object object = this.getValue("attachedPermanent");
        Player player = game.getPlayer(source.getControllerId());
        if (!(object instanceof Permanent) || player == null) {
            return false;
        }
        Permanent permanent = (Permanent)object;
        Permanent targetedPermanent = game.getPermanent(source.getFirstTarget());
        if (targetedPermanent == null) {
            Player targetedPlayer = game.getPlayer(source.getFirstTarget());
            if (targetedPlayer != null) {
                targetedPlayer.damage(2, permanent.getId(), source, game);
            }
        } else {
            targetedPermanent.damage(2, permanent.getId(), source, game);
        }
        return true;
    }

    public String getText(Mode mode) {
        String name = "Blazing Torch";
        Object object = this.getValue("attachedPermanent");
        if (object instanceof Permanent) {
            name = ((Permanent)object).getName();
        }
        return name + " deals 2 damage to any target.";
    }
}

