/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BlessedRespiteEffect
extends OneShotEffect {
    BlessedRespiteEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target player shuffles their graveyard into their library";
    }

    private BlessedRespiteEffect(BlessedRespiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlessedRespiteEffect copy() {
        return new BlessedRespiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            targetPlayer.moveCards((Cards)targetPlayer.getGraveyard(), Zone.LIBRARY, source, game);
            targetPlayer.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

