/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.turn.Step;

class BlindingBeamEffect2
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();
    private final UUID targetPlayerId;

    public BlindingBeamEffect2(UUID targetPlayerId) {
        super(Duration.Custom, Outcome.Detriment);
        this.targetPlayerId = targetPlayerId;
    }

    private BlindingBeamEffect2(BlindingBeamEffect2 effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.targetPlayerId = effect.targetPlayerId;
    }

    public BlindingBeamEffect2 copy() {
        return new BlindingBeamEffect2(this);
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getPhase().getStep().getType() == PhaseStep.UNTAP && game.getStep().getStepPart() == Step.StepPart.PRE && (game.isActivePlayer(this.targetPlayerId) || game.getPlayer(source.getControllerId()).hasReachedNextTurnAfterLeaving());
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        return game.getTurnStepType() == PhaseStep.UNTAP && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isControlledBy(this.targetPlayerId) && filter.match((Object)permanent, game);
    }
}

