/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BlinkmothUrnEffect
extends OneShotEffect {
    BlinkmothUrnEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "that player adds {C} for each artifact they control";
    }

    private BlinkmothUrnEffect(BlinkmothUrnEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlinkmothUrnEffect copy() {
        return new BlinkmothUrnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        FilterArtifactPermanent filter = new FilterArtifactPermanent("artifacts you control");
        filter.add((Predicate)new ControllerIdPredicate(game.getActivePlayerId()));
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            player.getManaPool().addMana(Mana.ColorlessMana((int)game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game).size()), game, source, false);
            return true;
        }
        return false;
    }
}

