/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class BloodClockEffect
extends OneShotEffect {
    BloodClockEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "that player returns a permanent they control to its owner's hand unless they pay 2 life";
    }

    private BloodClockEffect(BloodClockEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodClockEffect copy() {
        return new BloodClockEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        PayLifeCost cost = new PayLifeCost(2);
        if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Neutral, "Pay 2 life? If you don't, return a permanent you control to its owner's hand.", source, game) && cost.pay(source, game, source, player.getId(), true)) {
            return true;
        }
        TargetControlledPermanent target = new TargetControlledPermanent();
        target.withNotTarget(true);
        if (!target.canChoose(player.getId(), source, game) || !player.chooseTarget(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return player.moveCards((Card)permanent, Zone.HAND, source, game);
    }
}

