/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class BloodCurdleEffect
extends OneShotEffect {
    BloodCurdleEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put a menace counter on a creature you control. <i>(It can't be blocked except by two or more creatures.)</i>";
    }

    private BloodCurdleEffect(BloodCurdleEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodCurdleEffect copy() {
        return new BloodCurdleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return permanent.addCounters(CounterType.MENACE.createInstance(), source.getControllerId(), source, game);
    }
}

