/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BloodTributeGainLifeEffect
extends OneShotEffect {
    BloodTributeGainLifeEffect() {
        super(Outcome.GainLife);
        this.staticText = "If Blood Tribute was kicked, you gain life equal to the life lost this way";
    }

    private BloodTributeGainLifeEffect(BloodTributeGainLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodTributeGainLifeEffect copy() {
        return new BloodTributeGainLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer amount;
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && (amount = (Integer)game.getState().getValue(source.getSourceId().toString() + "_BloodTribute")) != null && amount > 0) {
            player.gainLife(amount.intValue(), game, source);
            return true;
        }
        return false;
    }
}

