/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class BloodletterOfAclazotzEffect
extends ReplacementEffectImpl {
    BloodletterOfAclazotzEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If an opponent would lose life during your turn, they lose twice that much life instead";
    }

    private BloodletterOfAclazotzEffect(BloodletterOfAclazotzEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BloodletterOfAclazotzEffect copy() {
        return new BloodletterOfAclazotzEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOSE_LIFE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.isActivePlayer(source.getControllerId()) && game.getOpponents(source.getControllerId()).contains(event.getPlayerId());
    }
}

