/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class BondOfInsightEffect
extends OneShotEffect {
    BondOfInsightEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player mills four cards. Return up to two instant and/or sorcery cards from your graveyard to your hand.";
    }

    private BondOfInsightEffect(BondOfInsightEffect effect) {
        super((OneShotEffect)effect);
    }

    public BondOfInsightEffect copy() {
        return new BondOfInsightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.millCards(4, source, game);
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 2, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }
}

