/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class BondOfRevivalEffect
extends OneShotEffect {
    BondOfRevivalEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature card from your graveyard to the battlefield. It gains haste until your next turn.";
    }

    private BondOfRevivalEffect(BondOfRevivalEffect effect) {
        super((OneShotEffect)effect);
    }

    public BondOfRevivalEffect copy() {
        return new BondOfRevivalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        if (player.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.UntilYourNextTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

